package fr.asip.cps3.exemple.vues.ecrans.saisie;

import java.awt.GridBagLayout;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.EmptyBorder;

import fr.asip.cps3.exemple.vues.FenetrePrincipale;
import fr.asip.cps3.exemple.vues.composants.GridBagHelper;
import fr.asip.cps3.exemple.vues.ecrans.EcranUtil;

/**
 * Classe permettant de modliser l'cran de saisie de 2 PIN
 */
public class Saisie2PIN extends Saisie1PIN {

	/**
	 * Libell PIN 2
	 */
	protected JLabel libellePIN2;
	
	/**
	 * Texte PIN 2
	 */
	protected JPasswordField textePIN2;
	
	/**
	 * Constructeur  2 arguments
	 * @param fenetre La fentre qui doit contenir l'cran de saisie
	 * @param typeEcran Type d'cran
	 */
	public Saisie2PIN(FenetrePrincipale fenetre, int typeEcran) {
		this(fenetre, typeEcran, "Entrez le code :", "R-entrez le code :");
	}

	/**
	 * Constructeur  3 arguments
	 * @param fenetre La fentre qui doit contenir l'cran de saisie
	 * @param typeEcran Type d'cran
	 * @param libelle1 Libell du champ PIN
	 * @param libelle2 Libell du champ PIN2
	 */
	public Saisie2PIN(FenetrePrincipale fenetre, int typeEcran, String libelle1, String libelle2) {

		super(fenetre,typeEcran);
		libellePIN = new JLabel(libelle1);
		libellePIN2 = new JLabel(libelle2);
		textePIN2 = new JPasswordField(32);
    	
	}
	
	/**
     * Renvoie le deuxime code PIN
     * @return Le deuxime code PIN
     */
	public char[] getPIN2() {
		if(textePIN2 != null)
			return textePIN2.getPassword();
		return null;
	}	
	
	/**
	 * Affiche les champs d'entre
	 */
    public void affiche() {

    	JFrame fenetre = this.fenetre.getFenetre();
    	
    	if(fenetre != null && fenetre.getContentPane() != null) {
    	
	    	EcranUtil.supprimeTousLesComposants(((JPanel)fenetre.getContentPane()));
	    	
	        // Cration du layout
	    	((JPanel)fenetre.getContentPane()).setBorder(new EmptyBorder(0, 0, 0, 0));
	        GridBagLayout layout = new GridBagLayout();
	        ((JPanel)fenetre.getContentPane()).setLayout(layout);
	        
	        // Ajout des composants
	        GridBagHelper g = new GridBagHelper(fenetre.getContentPane());
	        // Ligne 0
	        g.ajoute(libellePIN, EcranUtil.styleLibelleSaisie, 0, 0, 1, 1);
	        g.ajoute(textePIN, EcranUtil.styleChampTexteSaisie, 0, 1, 1, 1);
	        // Ligne 1
	        g.ajoute(libellePIN2, EcranUtil.styleLibelleSaisie, 1, 0, 1, 1);
	        g.ajoute(textePIN2, EcranUtil.styleChampTexteSaisie, 1, 1, 1, 1);
	        // Ligne 2	        
	        g.ajoute(soumettre, EcranUtil.styleBoutonSoumettre, 2, 0, 1, 2);
	        // Ligne 3
	        g.ajoute(barreStatut, EcranUtil.styleBarreStatut, 3, 0, 1, 2);
	        
    	}
    }
}
